/*
 * Decompiled with CFR 0.152.
 */
package lotr;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import lotr.common.entity.Dragons.entity.LOTREntityDragonAlpha;
import lotr.common.entity.Dragons.entity.LOTREntityDragonAnkalagon;
import lotr.common.entity.Dragons.entity.LOTREntityDragonHunter;
import lotr.common.entity.Dragons.entity.LOTREntityDragonScout;
import lotr.common.world.biome.LOTRBiomeGenErebor;
import lotr.common.world.biome.LOTRBiomeGenGreyMountains;
import lotr.common.world.biome.LOTRBiomeGenIronHills;
import lotr.common.world.biome.LOTRBiomeGenRedMountainsBlacklock;
import lotr.common.world.biome.LOTRBiomeGenRedMountainsIronfist;
import lotr.common.world.biome.LOTRBiomeGenRedMountainsStiffbeard;
import lotr.common.world.biome.LOTRBiomeGenRedMountainsStonefoot;
import lotr.common.world.biome.LOTRBiomeGenWindMountains;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ChunkEvent;

public class LOTRDragonEvents {
    private boolean dragonNotified = false;

    private boolean isDragonSpawnBiome(BiomeGenBase biome) {
        return biome instanceof LOTRBiomeGenGreyMountains || biome instanceof LOTRBiomeGenWindMountains || biome instanceof LOTRBiomeGenRedMountainsBlacklock || biome instanceof LOTRBiomeGenRedMountainsIronfist || biome instanceof LOTRBiomeGenIronHills || biome instanceof LOTRBiomeGenErebor || biome instanceof LOTRBiomeGenRedMountainsStiffbeard || biome instanceof LOTRBiomeGenRedMountainsStonefoot;
    }

    private boolean isPlayerNotInCreativeNear(ChunkEvent.Load event) {
        return event.world.field_73010_i.stream().filter(player -> player instanceof EntityPlayer).anyMatch(player -> !((EntityPlayer)player).field_71075_bZ.field_75098_d);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onChunkUnloadEvent(ChunkEvent.Unload event) {
        for (List l : event.getChunk().field_76645_j) {
            for (Entity el : l) {
                if (!(el instanceof LOTREntityDragonAnkalagon) && !(el instanceof LOTREntityDragonAlpha) && !(el instanceof LOTREntityDragonHunter) && !(el instanceof LOTREntityDragonScout)) continue;
                this.notifyPlayerDragonLeft(event, el);
                el.func_70106_y();
            }
        }
    }

    private void notifyPlayerDragonLeft(ChunkEvent.Unload event, Entity dragonEntity) {
        if (dragonEntity == null || !dragonEntity.func_70089_S() || this.dragonNotified) {
            return;
        }
        List players = event.world.field_73010_i;
        String dragonName = dragonEntity.func_70005_c_();
        String message = StatCollector.func_74837_a((String)"dragon_left", (Object[])new Object[]{dragonName});
        int chunkCenterX = event.getChunk().func_76632_l().func_77273_a();
        int chunkCenterZ = event.getChunk().func_76632_l().func_77274_b();
        int midY = event.world.func_72940_L() / 2;
        for (EntityPlayer player : players) {
            if (player.field_71075_bZ.field_75098_d || !(player.func_70092_e((double)chunkCenterX, (double)midY, (double)chunkCenterZ) < 65536.0)) continue;
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + message));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChunkLoadEvent(ChunkEvent.Load event) {
        BiomeGenBase biome = event.world.func_72807_a(event.getChunk().func_76632_l().func_77273_a(), event.getChunk().func_76632_l().func_77274_b());
        if (!this.isDragonSpawnBiome(biome)) {
            return;
        }
        List players = event.world.field_73010_i;
        boolean isPlayerNearby = players.stream().anyMatch(player -> {
            int chunkCenterX = event.getChunk().func_76632_l().func_77273_a();
            int chunkCenterZ = event.getChunk().func_76632_l().func_77274_b();
            double distance = player.func_70011_f((double)chunkCenterX, player.field_70163_u, (double)chunkCenterZ);
            int dynamicRadius = Math.max(256, (int)(distance / 2.0));
            return !player.field_71075_bZ.field_75098_d && distance < (double)dynamicRadius;
        });
        if (!isPlayerNearby) {
            return;
        }
        if (this.isDragonSpawnBiome(biome)) {
            int ankalagonselect;
            int alphaselect;
            int hunterselect;
            Block block;
            int mid;
            int scoutselect = (int)(1.0 + Math.random() * 2083.0);
            if (scoutselect == 1) {
                mid = event.world.func_72940_L() / 2;
                block = event.world.func_147439_a(event.getChunk().func_76632_l().func_77273_a(), mid, event.getChunk().func_76632_l().func_77274_b());
                if (block != null && block.func_149688_o() == Material.field_151579_a) {
                    LOTREntityDragonScout entityDragonScout = new LOTREntityDragonScout(event.world);
                    if (!entityDragonScout.field_70170_p.field_72995_K) {
                        entityDragonScout.func_70107_b(event.getChunk().func_76632_l().func_77273_a(), mid, event.getChunk().func_76632_l().func_77274_b());
                        event.world.func_72838_d((Entity)entityDragonScout);
                        this.notifyPlayerNearby(event, (Entity)entityDragonScout);
                    }
                    return;
                }
            }
            if ((hunterselect = (int)(1.0 + Math.random() * 3947.0)) == 1) {
                mid = event.world.func_72940_L() / 2;
                block = event.world.func_147439_a(event.getChunk().func_76632_l().func_77273_a(), mid, event.getChunk().func_76632_l().func_77274_b());
                if (block != null && block.func_149688_o() == Material.field_151579_a) {
                    LOTREntityDragonHunter entityDragonHunter = new LOTREntityDragonHunter(event.world);
                    if (!entityDragonHunter.field_70170_p.field_72995_K) {
                        entityDragonHunter.func_70107_b(event.getChunk().func_76632_l().func_77273_a(), mid, event.getChunk().func_76632_l().func_77274_b());
                        event.world.func_72838_d((Entity)entityDragonHunter);
                        this.notifyPlayerNearby(event, (Entity)entityDragonHunter);
                    }
                    return;
                }
            }
            if ((alphaselect = (int)(1.0 + Math.random() * 6153.0)) == 1) {
                mid = event.world.func_72940_L() / 2;
                block = event.world.func_147439_a(event.getChunk().func_76632_l().func_77273_a(), mid, event.getChunk().func_76632_l().func_77274_b());
                if (block != null && block.func_149688_o() == Material.field_151579_a) {
                    LOTREntityDragonAlpha entityDragonAlpha = new LOTREntityDragonAlpha(event.world);
                    if (!entityDragonAlpha.field_70170_p.field_72995_K) {
                        entityDragonAlpha.func_70107_b(event.getChunk().func_76632_l().func_77273_a(), mid, event.getChunk().func_76632_l().func_77274_b());
                        event.world.func_72838_d((Entity)entityDragonAlpha);
                        this.notifyPlayerNearby(event, (Entity)entityDragonAlpha);
                    }
                    return;
                }
            }
            if ((ankalagonselect = (int)(1.0 + Math.random() * 9333.0)) == 1) {
                mid = event.world.func_72940_L() / 2;
                block = event.world.func_147439_a(event.getChunk().func_76632_l().func_77273_a(), mid, event.getChunk().func_76632_l().func_77274_b());
                if (block != null && block.func_149688_o() == Material.field_151579_a) {
                    LOTREntityDragonAnkalagon entityDragonAnkalagon = new LOTREntityDragonAnkalagon(event.world);
                    if (!entityDragonAnkalagon.field_70170_p.field_72995_K) {
                        entityDragonAnkalagon.func_70107_b(event.getChunk().func_76632_l().func_77273_a(), mid, event.getChunk().func_76632_l().func_77274_b());
                        event.world.func_72838_d((Entity)entityDragonAnkalagon);
                        this.notifyPlayerNearby(event, (Entity)entityDragonAnkalagon);
                    }
                    return;
                }
            }
            return;
        }
    }

    private void notifyPlayerNearby(ChunkEvent.Load event, Entity dragonEntity) {
        if (dragonEntity == null || !dragonEntity.func_70089_S()) {
            return;
        }
        List players = event.world.field_73010_i;
        String dragonName = dragonEntity.func_70005_c_();
        double dragonPosX = dragonEntity.field_70165_t;
        double dragonPosZ = dragonEntity.field_70161_v;
        String message = StatCollector.func_74837_a((String)"dragon_spawned", (Object[])new Object[]{dragonName, dragonPosX, dragonPosZ});
        int chunkCenterX = event.getChunk().func_76632_l().func_77273_a();
        int chunkCenterZ = event.getChunk().func_76632_l().func_77274_b();
        int midY = event.world.func_72940_L() / 2;
        for (EntityPlayer player : players) {
            if (player.field_71075_bZ.field_75098_d || !(player.func_70092_e((double)chunkCenterX, (double)midY, (double)chunkCenterZ) < 65536.0)) continue;
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + message));
            player.field_70170_p.func_72956_a((Entity)player, "lotr:dragon", 1.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityDeathEvent(LivingDeathEvent event) {
        if (event.entity instanceof LOTREntityDragonAlpha || event.entity instanceof LOTREntityDragonAnkalagon || event.entity instanceof LOTREntityDragonHunter || event.entity instanceof LOTREntityDragonScout) {
            event.setCanceled(true);
        }
    }
}

